/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Generic Memory Functions header                    
::   Copyright   :   (C)2003-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   MPC5xx OS
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __MEMAPPFUNCS_H
#define __MEMAPPFUNCS_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <MemFuncs.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/
/* Legacy call that does not do anything anymore */
#define MemFlush(a)

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)


#pragma pack()

/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
E_Exceptions MemWriteSynch(void* AddrToWrite, void const* in_pDataToWriteBuffer, uint4 in_uBytesToWrite);
E_Exceptions MemReadSynch(void* out_pDataBufferToFillOnRead, void const* AddrToRead, uint4 in_uBytesToRead);

E_Exceptions MemSetSynch(void *AddrToWrite, uint1 in_u1ValueToSet, uint4 in_uBytesToSetWithValue);

bool1 MemInitAsynch(MemFuncCBackPtr, uint4 in_user_data_u4);

#endif /* __MEMAPPFUNCS_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/

